# AnyKernel3 Ramdisk Mod Script
# osm0sis @ xda-developers
#
# Modded for OrangeFox Recovery
# DarthJabba9 @ xda-developers
# 30 March 2021

SHOW_DEBUG_MESSAGES="0";
[ "$SHOW_DEBUG_MESSAGES" = "1" ] && set -o xtrace;

## AnyKernel setup
# begin properties
properties() { '
kernel.string=OrangeFox Initd Installer v20210329, by DarthJabba9
do.devicecheck=0
do.modules=0
do.cleanup=1
do.cleanuponabort=1
supported.versions=
supported.patchlevels=
'; } # end properties


# shell variables
block=/dev/block/bootdevice/by-name/boot;
is_slot_device=0;
ramdisk_compression=auto;


## AnyKernel methods (DO NOT CHANGE)
# import patching functions/variables - see for reference
. tools/ak3-core.sh;

# check for ROM SDK
tmp_sdk=$(getprop "ro.build.version.sdk");
[ -z "$tmp_sdk" ] && tmp_sdk=$(getprop "ro.vendor.build.version.sdk");
[ -z "$tmp_sdk" ] && tmp_sdk=$(getprop "ro.system.build.version.sdk");
[ -z "$tmp_sdk" ] && tmp_sdk=$(getprop "ro.odm.build.version.sdk");
[ -z "$tmp_sdk" ] && tmp_sdk=29; # default to Android 10

ROM_SDK=$(getprop "orangefox.rom.sdk");
[ -z "$ROM_SDK" ] && ROM_SDK="$tmp_sdk";

if [ $ROM_SDK -gt 29 ]; then
   ui_print " ";
   ui_print "- NOTE: this mod is experimental on your Android version (Android SDK=$ROM_SDK)";
   ui_print " ";
fi

## AnyKernel file attributes
# set permissions/ownership for included ramdisk files
set_perm_recursive 0 0 755 644 $ramdisk/*;
set_perm_recursive 0 0 750 750 $ramdisk/init* $ramdisk/sbin;

## AnyKernel install
dump_boot;

# begin ramdisk changes
# do we have a SAR build?
is_SAR() {
  local F=$(getprop "ro.build.system_root_image");
  [ "$F" = "true" ] && {
    echo "1";
    return;
  }

  F=$(getprop ro.twrp.sar);
  [ "$F" = "true" ] && {
    echo "1";
    return;
  }

  F=$(grep -s "/system_root" "/etc/fstab");
  [ -n "$F" ] && {
     echo "1";
     return;
  }

  [ -d "/system_root/system/" -a -d "/system_root/system/etc/" ] && {
    echo "1";
    return;
  }

  [ -L "/system" -a -d "/system_root" ] && {
    echo "1";
    return;
  }

  F=$(grep -s "/system_root" "/proc/mounts");
  [ -n "$F" ] && {
     echo "1";
     return;
  }
  
  echo "0";
}

THE_ROOT="";
INIT_RC="init.rc";

# check for system_root 
ROM_SAR=$(is_SAR);
if [ "$SHOW_DEBUG_MESSAGES" = "1" ]; then
   ls -all /;
   ls -all /system/;
   ls -all /system/etc/;
   [ "$SAR" = "1" ] && {
      ls -all /system_root/;
      ls -all /system_root/etc/;
   }
   ls -all $home;
fi

# SAR
if [ "$ROM_SAR" = "1" -a -d "/system_root/system/" -a -d "/system_root/system/etc/" ]; then
   ui_print "- OrangeFox: proceeding in system-as-root mode...";
   ui_print "- Mounting /system_root in read-write mode...";
   THE_ROOT="/system_root";
   mount -o rw,remount $THE_ROOT;
   sleep 1;
 
   THE_ROOT=$THE_ROOT"/";  
   ui_print "- Copying files manually...";
   cp -fp $home/ramdisk/init.dj9.rc $THE_ROOT;
   
   if [ $ROM_SDK -gt 29 ]; then
      if [ ! -e $THE_ROOT"$INIT_RC" ]; then
         INIT_RC="/system/etc/init/hw/init.rc";
      fi
   fi
   
   cd $THE_ROOT;
else
   ui_print "- OrangeFox: proceeding in standard mode...";
   ui_print "- Mounting /system in read-write mode...";
   mount -o rw,remount /system;
   sleep 1;
fi
# end: system-as-root #

cp -af $home/ramdisk/sbin/* $THE_ROOT/system/bin;

# init.rc
# note - don't use "/init.rc", because "/" will be pointing to the recovery's "/" directory; just use "init.rc"
init_rc=$THE_ROOT"$INIT_RC"
[ -e $init_rc ] && backup_file $init_rc;
insert_line $init_rc "init.dj9.rc" before "on early-init" "import /init.dj9.rc";
# end ramdisk changes

write_boot;

cd /tmp;
sync;
if [ "$ROM_SAR" = "1" ]; then
   umount $THE_ROOT > /dev/null 2>&1;
else
   umount /system > /dev/null 2>&1;
fi
## end install
